/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemManaTablet
extends Item {
    public static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_CREATIVE = "creative";
    private static final String TAG_ONE_USE = "oneUse";

    public ItemManaTablet(Item.Properties props) {
        super(props);
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.m_41389_(tab)) {
            stacks.add((Object)new ItemStack((ItemLike)this));
            ItemStack fullPower = new ItemStack((ItemLike)this);
            ItemManaTablet.setMana(fullPower, 500000);
            stacks.add((Object)fullPower);
            ItemStack creative = new ItemStack((ItemLike)this);
            ItemManaTablet.setMana(creative, 500000);
            ItemManaTablet.setStackCreative(creative);
            stacks.add((Object)creative);
        }
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return ItemManaTablet.isStackCreative(stack) ? Rarity.EPIC : super.m_41460_(stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        if (ItemManaTablet.isStackCreative(stack)) {
            stacks.add((Component)new TranslatableComponent("botaniamisc.creative").m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    public static void setStackCreative(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
    }

    public static boolean isStackCreative(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
    }

    public boolean m_142522_(ItemStack stack) {
        return !ItemManaTablet.isStackCreative(stack);
    }

    public int m_142158_(ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int m_142159_(ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItem
    implements IManaItem {
        private final ItemStack stack;

        public ManaItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            if (ItemManaTablet.isStackCreative(this.stack)) {
                return this.getMaxMana();
            }
            return ItemNBTHelper.getInt(this.stack, ItemManaTablet.TAG_MANA, 0) * this.stack.m_41613_();
        }

        @Override
        public int getMaxMana() {
            return (ItemManaTablet.isStackCreative(this.stack) ? 501000 : 500000) * this.stack.m_41613_();
        }

        @Override
        public void addMana(int mana) {
            if (!ItemManaTablet.isStackCreative(this.stack)) {
                ItemManaTablet.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.m_41613_());
            }
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return !ItemNBTHelper.getBoolean(this.stack, ItemManaTablet.TAG_ONE_USE, false);
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return !ItemManaTablet.isStackCreative(this.stack);
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

